﻿//---------------------------------------------------------------------------------
// Microsoft (R) .NET Services SDK
// Software Development Kit
// 
// Copyright (c) Microsoft Corporation. All rights reserved.  
//
// THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, 
// EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE. 
//---------------------------------------------------------------------------------

namespace Microsoft.AccessControl.ASPNET
{
    using System;
    using System.Collections;
    using System.Collections.Generic;
    using System.Security;
    using System.Security.Principal;
    using System.Web;
    using System.Web.Security;

    public class ServiceUser : IPrincipal
    {
        IIdentity identity = null;
        string[] roles;

        internal ServiceUser(string token, TokenValidator validator)
        {
            if (token == null)
            {
                throw new ArgumentNullException("token");
            }

            // set the identity field
            ServiceIdentity identity = new ServiceIdentity(token, validator);

            List<string> roleClaims = new List<string>();

            foreach (KeyValuePair<string, string> claim in identity.Claims)
            {
                if (claim.Key.Equals("role", StringComparison.OrdinalIgnoreCase))
                {
                    roleClaims.Add(claim.Value);
                }
            }

            this.roles = roleClaims.ToArray();

            this.identity = identity as IIdentity;
        }

        public IIdentity Identity
        {
            get
            {
                return this.identity;
            }
        }

        public bool IsInRole(string role)
        {
            // Look up role
            foreach (string testRole in this.roles)
            {
                if (role.Equals(testRole, StringComparison.OrdinalIgnoreCase))
                {
                    return true;
                }
            }

            return false;
        }
    }
}
